﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using AZVIC.Ei8htPOS.WebUI;
using AZVIC.Ei8htPOS.WebUI.Admin.WebService;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml.Linq;

namespace AZVIC.Ei8htPOS.WebUI.Admin.POS
{
    public partial class QuotationPOS : System.Web.UI.Page
    {
        private static List<Products> pList;
        private static List<ProductCategory> pCategory;
        private UserAccount currentUser = null;
        private static bool GstApplied;

        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);
            hdnIsHappyHour.Value = WebSession.IsHappyHour ? "1" : "0";
            if (!IsPostBack)
            {
                BindCountry();
                BindUserList(string.Empty, DateTime.MinValue, DateTime.MinValue);
                LoadProducts(string.Empty);
                LoadTax();
                LoadTables();
                GstApplied = WebSession.ApplyGST;
                ScriptManager.RegisterStartupScript(this, this.GetType(), "Open Table", "ShowSelectTable();", true);
            }
        }

        #region PageLoad Items
        private void BindCountry()
        {
            var doc = XDocument.Load(Server.MapPath("~/Resources/Countries.xml"));
            var countries = from c in doc.Descendants("country")
                            select c.Value;

            ddlCountry.DataSource = countries;
            ddlCountry.DataBind();

            ddlCountry.Items.FindByText("Singapore").Selected = true;
        }

        private void BindUserList(string searchWord, DateTime fromDate, DateTime toDate)
        {
            List<UserAccount> pbList = UserAccountBL.GetList(Guid.Empty, string.Empty, string.Empty, searchWord, fromDate, toDate);
            pbList = (from pb in pbList
                      where pb.UserRoleType.Trim().ToLower() == "user" && pb.IsActive
                      orderby pb.CreatedDate descending
                      select pb).ToList<UserAccount>();

            grdCustomers.DataSource = pbList;
            grdCustomers.DataBind();
        }

        private void LoadProducts(string searchKeyword)
        {
            pList = ProductsBL.GetList(Guid.Empty, string.Empty);
            pList = (from p in pList
                     where (p.IsActive && p.IsMiscellaneous == false && searchKeyword == string.Empty || (p.ProductName.ToLower().Contains(searchKeyword.ToLower()) ||
                                                              p.ProductDescriptions.ToLower().Contains(searchKeyword.ToLower()) ||
                                                              p.ProductCode.ToLower().Contains(searchKeyword.ToLower()) ||
                                                              p.AdditionalInfo.ToLower().Contains(searchKeyword.ToLower()) ||
                                                              p.ProductCategoryID.ToString().ToLower().Contains(searchKeyword.ToLower()) ||
                                                              p.UnitPrice.ToString().ToLower().Contains(searchKeyword.ToLower())))
                     group p by p.ProductName into g
                     select g.First()).ToList<Products>();

            rpProducts.DataSource = pList;
            rpProducts.DataBind();
            rpProductsGrid.DataSource = pList;
            rpProductsGrid.DataBind();

            pCategory = ProductCategoryBL.GetList(Guid.Empty, string.Empty);
            if (pCategory != null && pCategory.Count > 0)
            {
                pCategory = pCategory.Where(a => a.IsActive).ToList<Entities.ProductCategory>();
            }
            rpCategories.DataSource = pCategory;
            rpCategories.DataBind();

        }

        private void LoadTables()
        {
            List<Layouts> Layouts = LayoutBL.GetList(Guid.Empty);
            if (Layouts != null && Layouts.Count > 0)
            {
                Layouts = Layouts.Where(a => a.IsActive).ToList<Layouts>();
            }
            rpTables.DataSource = Layouts;
            rpTables.DataBind();
        }

        private void LoadTax()
        {
            List<Tax> Taxes = TaxBL.GetList(Guid.Empty, string.Empty);
            gvTax.DataSource = Taxes;
            gvTax.DataBind();
        }
        #endregion

        #region Discount
        protected void btnDiscount_Click(object sender, EventArgs e)
        {
            lblDiscountError.Text = string.Empty;

            if (WebSession.CurrentPOSOrders != null && WebSession.CurrentPOSOrders.OrdersDetailsList.Count > 0)
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "azvic", "$(function(){ $('#divDiscount').modal();});", true);
            }
            else
                WebUtilities.ShowMessage(this, "You must add any item to apply discount");
        }

        protected void btnApplyDiscount_Click(object sender, EventArgs e)
        {
            lblDiscountError.Text = string.Empty;
            bool showPopup = false;
            if (ddlDiscountType.SelectedValue != "0")
            {
                if (ValidationUtility.ValidateDecimal(txtDiscountValue.Text.Trim()))
                {
                    if (ddlDiscountType.SelectedValue.Trim().ToLower().Equals("dollar"))
                    {
                        WebSession.CurrentPOSOrders.TotalDiscount = decimal.Parse(txtDiscountValue.Text.Trim());
                    }
                    else if (ddlDiscountType.SelectedValue.Trim().ToLower().Equals(Constants.DISCOUNT_PERCENTAGE))
                    {
                        WebSession.CurrentPOSOrders.TotalDiscount = WebSession.CurrentPOSOrders.SubTotal * decimal.Parse(txtDiscountValue.Text.Trim()) / 100;
                    }
                    showPopup = false;
                }
                else
                {
                    lblDiscountError.Text = "Please enter valid Discount";
                    txtDiscountValue.Focus();
                    showPopup = true;
                }
            }
            else
            {
                lblDiscountError.Text = "Please select Discount Type";
                ddlDiscountType.Focus();
                showPopup = true;
            }

            if (showPopup)
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "azvic", "$(function(){ $('#divDiscount').modal();});", true);
            }
        }
        #endregion

        #region Edit Product
        protected void lnkProduct_Click(object sender, EventArgs e)
        {
            lblPError.Text = string.Empty;
            hdProductID.Value = string.Empty;
            LinkButton lnkProduct = (LinkButton)sender;
            if (lnkProduct != null)
            {
                hdProductID.Value = lnkProduct.CommandArgument.ToString();
                Guid productID = new Guid(hdProductID.Value);
                OrdersDetails myOD = WebSession.CurrentPOSOrders.OrdersDetailsList.Where(od => od.ProductID == productID).FirstOrDefault<OrdersDetails>();

                if (myOD != null)
                {
                    //txtQty.Text = myOD.Quantity.ToString();
                    txtPrice.Text = myOD.OrderPrice.ToString("0.00");
                    txtDiscount.Text = myOD.DiscountValue.ToString("0.00");
                    ddlProductDiscType.SelectedIndex = string.IsNullOrEmpty(myOD.DiscountType) || myOD.DiscountType == Constants.DISCOUNT_PERCENTAGE ? 0 : 1;

                    ScriptManager.RegisterStartupScript(this, GetType(), "azvic", "$(function(){ $('#divProduct').modal();});", true);
                }
            }
        }
        private bool ValidateDiscountChange()
        {
            bool success = true;
            if (!ValidationUtility.ValidateDecimal(txtPrice.Text.Trim()))
                success = false;
            if (!string.IsNullOrEmpty(txtDiscount.Text) && !ValidationUtility.ValidateDecimal(txtDiscount.Text.Trim()))
            {
                success = false;
            }
            return success;
        }

        protected void btnUpdateProduct_Click(object sender, EventArgs e)
        {
            bool showPopup = false;
            if (ValidateDiscountChange())
            {
                if (hdProductID.Value.Trim().Length != 0)
                {
                    string remarks = string.Empty;
                    Guid productID = new Guid(hdProductID.Value);
                    Products curProduct = ProductsBL.GetItem(productID, string.Empty);
                    decimal DiscountValue = string.IsNullOrEmpty(txtDiscount.Text) ? 0M : decimal.Parse(txtDiscount.Text.Trim());
                    decimal CurrPrice = decimal.Parse(txtPrice.Text.Trim());
                    if (CurrPrice >= DiscountValue || (ddlProductDiscType.SelectedValue.ToLower().Equals(Constants.DISCOUNT_PERCENTAGE) && DiscountValue <= 100))
                    {
                        int CurrQty = WebSession.CurrentPOSOrders.OrdersDetailsList.Where(a => a.ProductID == productID).Select(a => a.Quantity).Single();
                        WebSession.AddProductToCart(WebSession.CurrentPOSOrders, curProduct, CurrPrice, CurrQty, true);

                        WebSession.CurrentPOSOrders.OrdersDetailsList.Where(a => a.ProductID == productID).Single().DiscountType = ddlProductDiscType.SelectedValue;
                        WebSession.CurrentPOSOrders.OrdersDetailsList.Where(a => a.ProductID == productID).Single().DiscountValue = DiscountValue;

                        lblPError.Text = hdProductID.Value = txtPrice.Text = string.Empty;
                        decimal discount = 0;
                        foreach (OrdersDetails od in WebSession.CurrentPOSOrders.OrdersDetailsList)
                        {
                            if (od.DiscountType != null)
                            {
                                if (od.DiscountType.Trim().ToLower().Equals("dollar"))
                                {
                                    discount += (od.Quantity * od.DiscountValue);
                                }
                                else if (od.DiscountType.Trim().ToLower().Equals(Constants.DISCOUNT_PERCENTAGE))
                                {
                                    discount += (od.Quantity * (od.OrderPrice * od.DiscountValue / 100));
                                }
                            }
                        }
                        WebSession.CurrentPOSOrders.Discount = discount;

                    }
                    else
                    {
                        //if discount exceeds price
                        lblPError.Text = "Discount amount should not exceed Item price";
                        txtDiscount.Focus();
                        showPopup = true;
                    }
                }

            }
            else
            {
                lblPError.Text = "Please enter valid Price";
                txtPrice.Focus();
                showPopup = true;
            }

            if (showPopup)
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "azvic", "$(function(){ $('#divProduct').modal();});", true);
            }
        }
        #endregion

        #region Add Or Select Customer
        protected void lnkAddCustomer_Click(object sender, EventArgs e)
        {
            hdSelectedUser.Value = lblCError.Text = string.Empty;
            PopulateCustomerData();
            ScriptManager.RegisterStartupScript(this, GetType(), "azvic", "$(function(){ $('#divCustomer').modal(); $('#customertabs').tab();});", true);
        }

        protected void btnSaveCustomer_Click(object sender, EventArgs e)
        {
            if (hdSelectedUser.Value == string.Empty)
            {
                if (ValidateCustomer())
                {
                    #region Save Customer
                    currentUser = new UserAccount();

                    currentUser.Mode = GlobalConfigurations.Mode.Insert;
                    currentUser.UserName = txtEmail.Text.Trim();
                    currentUser.UPassword = ValidationUtility.EncryptPassword(Membership.GeneratePassword(8, 0));
                    //currentUser.CompanyName = txtCompanyName.Text.Trim();
                    currentUser.Salutation = ddlSalutation.SelectedValue != "0" ? ddlSalutation.SelectedValue : string.Empty;
                    currentUser.FirstName = txtFirstName.Text.Trim();
                    currentUser.LastName = txtLastName.Text.Trim();
                    //currentUser.NRICNo = txtNRIC.Text.Trim();
                    currentUser.Email = txtEmail.Text.Trim();
                    currentUser.MobileNo = txtMobileNo.Text.Trim();
                    currentUser.PhoneNo = txtPhoneNo.Text.Trim();
                    currentUser.Address1 = txtAddress1.Text.Trim();
                    currentUser.Address2 = txtAddress2.Text.Trim();
                    currentUser.City = txtCity.Text.Trim();
                    currentUser.StateProvince = txtState.Text.Trim();
                    currentUser.Country = ddlCountry.SelectedValue != "0" ? ddlCountry.SelectedItem.Text : string.Empty;
                    currentUser.PostalCode = txtPostalCode.Text.Trim();
                    //currentUser.Occupation = txtOccupation.Text.Trim();
                    currentUser.UserRoleType = "User";
                    currentUser.IsApproved = true;
                    currentUser.IsSubscribed = true;
                    currentUser.IsActive = true;
                    currentUser.AdminUserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);

                    if (UserAccountBL.Save(currentUser))
                    {
                        BindUserList(string.Empty, DateTime.MinValue, DateTime.MinValue);
                        WebSession.CurrentPOSOrders.UsersAccountID = currentUser.UniqueID;
                        //WebSession.CurrentPOSOrders.Company = currentUser.CompanyName;
                        WebSession.CurrentPOSOrders.FirstName = currentUser.FirstName;
                        WebSession.CurrentPOSOrders.LastName = currentUser.LastName;
                        WebSession.CurrentPOSOrders.Email = currentUser.Email;
                        WebSession.CurrentPOSOrders.BillingAddress1 = currentUser.Address1;
                        WebSession.CurrentPOSOrders.BillingAddress2 = currentUser.Address2;
                        WebSession.CurrentPOSOrders.BillingCity = currentUser.City;
                        WebSession.CurrentPOSOrders.BillingState = currentUser.StateProvince;
                        WebSession.CurrentPOSOrders.BillingCountry = currentUser.Country;
                        WebSession.CurrentPOSOrders.BillingPostalCode = currentUser.PostalCode;
                        WebSession.CurrentPOSOrders.BillingPhone = currentUser.PhoneNo;
                        WebSession.CurrentPOSOrders.BillingMobile = currentUser.MobileNo;
                        WebSession.CurrentPOSOrders.IsShipToBillingAddress = true;
                        if (WebSession.CurrentPOSOrders.IsShipToBillingAddress)
                        {
                            WebSession.CurrentPOSOrders.ShippingAddress1 = WebSession.CurrentPOSOrders.BillingAddress1;
                            WebSession.CurrentPOSOrders.ShippingAddress2 = WebSession.CurrentPOSOrders.BillingAddress2;
                            WebSession.CurrentPOSOrders.ShippingCity = WebSession.CurrentPOSOrders.BillingCity;
                            WebSession.CurrentPOSOrders.ShippingState = WebSession.CurrentPOSOrders.BillingState;
                            WebSession.CurrentPOSOrders.ShippingCountry = WebSession.CurrentPOSOrders.BillingCountry;
                            WebSession.CurrentPOSOrders.ShippingPostalCode = WebSession.CurrentPOSOrders.BillingPostalCode;
                            WebSession.CurrentPOSOrders.ShippingPhone = WebSession.CurrentPOSOrders.BillingPhone;
                            WebSession.CurrentPOSOrders.ShippingMobile = WebSession.CurrentPOSOrders.BillingMobile;
                        }
                    }
                    lblCustomerName.Text = currentUser.FirstName;
                    #endregion
                }
                else
                {
                    ScriptManager.RegisterStartupScript(this, GetType(), "azvic", "$(function(){ $('#divCustomer').modal();$('#customertabs').tabs();});", true);
                }
            }
        }

        private bool ValidateCustomer()
        {
            //if (!ValidationUtility.ValidateString(txtCompanyName.Text.Trim()))
            //{
            //    lblCError.Text = "Please enter Company Name";
            //    txtCompanyName.Focus();
            //    return false;
            //}
            if (!ValidationUtility.ValidateString(txtFirstName.Text.Trim()))
            {
                lblCError.Text = "Please enter First Name";
                txtFirstName.Focus();
                return false;
            }
            if (!ValidationUtility.ValidateString(txtLastName.Text.Trim()))
            {
                lblCError.Text = "Please enter Last Name";
                txtLastName.Focus();
                return false;
            }
            if (!ValidationUtility.ValidateEmail(txtEmail.Text.Trim()))
            {
                lblCError.Text = "Please enter valid Email";
                txtEmail.Focus();
                return false;
            }

            if (txtEmail.Text.Trim().Length != 0)
            {
                List<UserAccount> listUser = UserAccountBL.GetList(Guid.Empty, string.Empty, string.Empty, txtEmail.Text.Trim(), DateTime.MinValue, DateTime.MinValue);
                if (listUser != null && listUser.Count > 0)
                {
                    listUser = listUser.Where(a => a.IsActive).ToList<UserAccount>();
                }
                if (listUser.Count > 0)
                {
                    lblCError.Text = "Email already registered with Azvic.<br>Please try again with another email address.";
                    return false;
                }
            }

            return true;
        }

        protected void lnkSelect_Click(object sender, EventArgs e)
        {
            LinkButton btnSelected = sender as LinkButton;

            if (btnSelected != null)
            {
                Guid userID = Guid.Parse(btnSelected.CommandArgument);
                currentUser = UserAccountBL.GetItem(userID, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
                if (currentUser != null)
                {
                    hdSelectedUser.Value = currentUser.UniqueID.ToString();
                    WebSession.CurrentPOSOrders.UsersAccountID = currentUser.UniqueID;
                    //WebSession.CurrentPOSOrders.Company = currentUser.CompanyName;
                    WebSession.CurrentPOSOrders.FirstName = currentUser.FirstName;
                    WebSession.CurrentPOSOrders.LastName = currentUser.LastName;
                    WebSession.CurrentPOSOrders.Email = currentUser.Email;
                    WebSession.CurrentPOSOrders.BillingAddress1 = currentUser.Address1;
                    WebSession.CurrentPOSOrders.BillingAddress2 = currentUser.Address2;
                    WebSession.CurrentPOSOrders.BillingCity = currentUser.City;
                    WebSession.CurrentPOSOrders.BillingState = currentUser.StateProvince;
                    WebSession.CurrentPOSOrders.BillingCountry = currentUser.Country;
                    WebSession.CurrentPOSOrders.BillingPostalCode = currentUser.PostalCode;
                    WebSession.CurrentPOSOrders.BillingPhone = currentUser.PhoneNo;
                    WebSession.CurrentPOSOrders.BillingMobile = currentUser.MobileNo;
                    WebSession.CurrentPOSOrders.IsShipToBillingAddress = true;

                    if (WebSession.CurrentPOSOrders.IsShipToBillingAddress)
                    {
                        WebSession.CurrentPOSOrders.ShippingAddress1 = WebSession.CurrentPOSOrders.BillingAddress1;
                        WebSession.CurrentPOSOrders.ShippingAddress2 = WebSession.CurrentPOSOrders.BillingAddress2;
                        WebSession.CurrentPOSOrders.ShippingCity = WebSession.CurrentPOSOrders.BillingCity;
                        WebSession.CurrentPOSOrders.ShippingState = WebSession.CurrentPOSOrders.BillingState;
                        WebSession.CurrentPOSOrders.ShippingCountry = WebSession.CurrentPOSOrders.BillingCountry;
                        WebSession.CurrentPOSOrders.ShippingPostalCode = WebSession.CurrentPOSOrders.BillingPostalCode;
                        WebSession.CurrentPOSOrders.ShippingPhone = WebSession.CurrentPOSOrders.BillingPhone;
                        WebSession.CurrentPOSOrders.ShippingMobile = WebSession.CurrentPOSOrders.BillingMobile;
                    }
                    lblCustomerName.Text = currentUser.FirstName;
                }
            }
        }

        private void PopulateCustomerData()
        {
            if (WebSession.CurrentPOSOrders != null)
            {
                if (WebSession.CurrentPOSOrders.UsersAccountID != Guid.Empty && WebSession.CurrentPOSOrders.UsersAccountID != null)
                {
                    hdSelectedUser.Value = WebSession.CurrentPOSOrders.UsersAccountID.ToString();
                    //txtCompanyName.Text = WebSession.CurrentPOSOrders.Company;
                    txtFirstName.Text = WebSession.CurrentPOSOrders.FirstName;
                    txtLastName.Text = WebSession.CurrentPOSOrders.LastName;
                    txtEmail.Text = WebSession.CurrentPOSOrders.Email;
                    txtAddress1.Text = WebSession.CurrentPOSOrders.BillingAddress1;
                    txtAddress2.Text = WebSession.CurrentPOSOrders.BillingAddress2;
                    txtCity.Text = WebSession.CurrentPOSOrders.BillingCity;
                    txtState.Text = WebSession.CurrentPOSOrders.BillingState;
                    ddlCountry.SelectedIndex = ddlCountry.Items.IndexOf(ddlCountry.Items.FindByValue(WebSession.CurrentPOSOrders.BillingCountry));
                    txtPostalCode.Text = WebSession.CurrentPOSOrders.BillingPostalCode;
                    txtMobileNo.Text = WebSession.CurrentPOSOrders.BillingMobile;
                    txtPhoneNo.Text = WebSession.CurrentPOSOrders.BillingPhone;
                }
            }
        }
        #endregion

        protected void lnkSelectTax_ServerClick(object sender, EventArgs e)
        {
            WebSession.CurrentPOSOrders.OrdersTax = null;
            List<Tax> Taxes = TaxBL.GetList(Guid.Empty, string.Empty);
            List<OrdersTax> ordTax = new List<OrdersTax>();
            OrdersTax ordTaxItem;
            for (int i = 0; i < gvTax.Rows.Count; i++)
            {
                CheckBox chk = gvTax.Rows[i].Cells[0].FindControl("chkSelectTax") as CheckBox;
                if (chk.Enabled && chk.Checked)
                {
                    Guid TaxID = Guid.Parse(gvTax.DataKeys[i].Value.ToString());
                    Tax currTax = Taxes.Where(a => a.TaxID == TaxID).Single();
                    ordTaxItem = new OrdersTax();
                    ordTaxItem.TaxID = currTax.TaxID;
                    ordTaxItem.TaxName = currTax.TaxName;
                    ordTaxItem.TaxType = currTax.TaxType;
                    ordTaxItem.TaxValue = currTax.TaxValue;
                    ordTax.Add(ordTaxItem);
                }
            }
            WebSession.CurrentPOSOrders.OrdersTax = ordTax;
        }

        protected void lnkSelectTable_ServerClick(object sender, EventArgs e)
        {
            hdnTableName.Value = (sender as Button).Text;
        }

        protected void lnkPrintToKitchen_ServerClick(object sender, EventArgs e)
        {
            if (WebSession.CurrentPOSOrders != null && WebSession.CurrentPOSOrders.OrdersDetailsList.Count() > 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "Send to Kitchen", "SendToKitchen();", true);
            }
            else
                ShowNotification("Please add any item to the cart before sending the order to Kitchen");
        }

        protected void lnkVoidTransaction_Click(object sender, EventArgs e)
        {
            WebSession.CurrentPOSOrders = new Orders();
            WebSession.CurrentPOSOrders.Mode = GlobalConfigurations.Mode.Insert;
            LoadTax();
            LoadProducts(string.Empty);
            //BindShoppingCart();
        }

        protected void lnkSettle_Click(object sender, EventArgs e)
        {
            lblPayError.Text = string.Empty;

            if (WebSession.CurrentPOSOrders != null && WebSession.CurrentPOSOrders.OrdersDetailsList.Count > 0)
            {
                //if (WebSession.CurrentPOSOrders.UsersAccountID != Guid.Empty && WebSession.CurrentPOSOrders.UsersAccountID != null)
                //{
                lblPayTotal.Text = WebSession.CurrentPOSOrders.Total.ToString("SGD 0.00");
                ScriptManager.RegisterStartupScript(this, GetType(), "azvic", "$(function(){ $('#divPayment').modal();});", true);
                LoadReceipt();
                //}
                //else
                //{
                //    ScriptManager.RegisterStartupScript(this, GetType(), "azvic", "$(function(){ $('#divCustomer').modal(); $('#customertabs').tab();});", true);
                //}
            }
            else
                WebUtilities.ShowMessage(this, "You must add any item to make order");
        }

        private void LoadReceipt()
        {
            lblReceiptCashier.Text = WebSession.CurrentAdminUser.FirstName;
            lblReceiptCustName.Text = WebSession.CurrentPOSOrders.FirstName;
            lblReceiptNo.Text = "";
            lblReceiptTableNumber.Text = WebSession.CurrentPOSOrders.TableNumber;
            rptProductsReceipt.DataSource = WebSession.CurrentPOSOrders.OrdersDetailsList;
            rptProductsReceipt.DataBind();
            lblReceiptSubtotalVal.Text = WebSession.CurrentPOSOrders.SubTotal.ToString("$ 0.00") + "<br/>";
            lblReceiptSrvChrgeVal.Text = WebSession.CurrentPOSOrders.ServiceTax.ToString("$ 0.00") + "<br/>";
            lblReceiptTotalVal.Text = WebSession.CurrentPOSOrders.Total.ToString("$ 0.00") + "<br/>";

            if (WebSession.CurrentPOSOrders.Discount > 0M)
            {
                lblReceiptItemDiscount.Visible = true;
                lblReceiptItemDiscountVal.Visible = true;
                lblReceiptItemDiscountVal.Text = WebSession.CurrentPOSOrders.Discount.ToString("$ 0.00") + "<br/>";
            }
            else
            {
                lblReceiptItemDiscount.Visible = false;
                lblReceiptItemDiscountVal.Visible = false;
            }

            if (WebSession.CurrentPOSOrders.TotalDiscount > 0M)
            {
                lblReceiptTotalDisc.Visible = true;
                lblReceiptTotalDiscVal.Visible = true;
                lblReceiptTotalDiscVal.Text = WebSession.CurrentPOSOrders.TotalDiscount.ToString("$ 0.00") + "<br/>";
            }
            else
            {
                lblReceiptTotalDisc.Visible = false;
                lblReceiptTotalDiscVal.Visible = false;
            }
            
        }

        protected void btnSaveOrder_Click(object sender, EventArgs e)
        {
            bool showPopup = false;
            if (ddlPayMethod.SelectedValue != "0")
            {
                if (ValidationUtility.ValidateDecimal(txtPaidAmount.Text.Trim()))
                {
                    decimal paid = 0;
                    decimal.TryParse(txtPaidAmount.Text.Trim(), out paid);

                    WebSession.CurrentPOSOrders.PaidAmount = paid;
                    WebSession.CurrentPOSOrders.AdminUserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);
                    WebSession.CurrentPOSOrders.IsShipToBillingAddress = true;
                    WebSession.CurrentPOSOrders.OrderFrom = WebSession.OrdersFrom;
                    WebSession.CurrentPOSOrders.PaymentMethod = ddlPayMethod.SelectedValue;
                    WebSession.CurrentPOSOrders.PaymentStatus = (WebSession.CurrentPOSOrders.PaidAmount >= WebSession.CurrentPOSOrders.Total) ? "Completed" : "Pending";
                    WebSession.CurrentPOSOrders.OrderStatus = "Delivered";

                    if (paid > 0)
                    {
                        WebSession.CurrentPOSOrders.OrdersPaymentList.Add(new OrdersPayment()
                        {
                            PaidAmount = paid,
                            PaymentMethod = ddlPayMethod.SelectedValue,
                            AdminUserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty)
                        });
                    }

                    int days = WebSession.CurrentPOSOrders.OrdersDetailsList.Max(i => i.EarliestAvailableDays);
                    WebSession.CurrentPOSOrders.EarliestAvailableDate = DateTime.Now.AddDays(days);

                    if (OrdersBL.Save(WebSession.CurrentPOSOrders))
                    {
                        OrdersBL.GenerateInvoice(WebSession.CurrentPOSOrders.UniqueID);
                        WebSession.UpdateOrderProductQty(WebSession.CurrentPOSOrders);
                        WebSession.CurrentPOSOrders = OrdersBL.GetItem(WebSession.CurrentPOSOrders.UniqueID, Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);

                        ddlPayMethod.SelectedIndex = -1;
                        lblCError.Text = lblPayError.Text = lblPayTotal.Text = txtPaidAmount.Text = string.Empty;
                        //Response.Redirect("QuotationPOS.aspx", false);
                        ScriptManager.RegisterStartupScript(this, this.GetType(), "OpenSuccess", "OpenSuccessPopup();", true);
                        PrintReceipt();
                    }

                    showPopup = false;
                }
                else
                {
                    lblPayError.Text = "Please enter valid Price";
                    txtPaidAmount.Focus();
                    showPopup = true;
                }
            }
            else
            {
                lblPayError.Text = "Please select valid Payment Method";
                ddlPayMethod.Focus();
                showPopup = true;
            }

            if (showPopup)
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "azvic", "$(function(){ $('#divPayment').modal();});", true);
            }
        }

        private void ShowNotification(string HTMLString)
        {
            divNotification.Visible = true;
            lblNotification.Text = HTMLString;
        }

        protected void btnDeleteCustomer_Click(object sender, EventArgs e)
        {
            Button Customer = sender as Button;
            Guid CustomerID = Guid.Parse(Customer.Attributes["data-CustomerID"].ToString());
            if (UserAccountBL.Delete(CustomerID))
            {
                ShowNotification("User Removed successfully");
                BindUserList(string.Empty, DateTime.MinValue, DateTime.MinValue);
                ScriptManager.RegisterStartupScript(this, GetType(), "azvic", "$(function(){ $('#divCustomer').modal(); $('#customertabs').tab();});", true);
            }
        }

        protected void btnCancelTax_Click(object sender, EventArgs e)
        {
            LoadTax();
        }

        protected void btnTableSelect_Click(object sender, EventArgs e)
        {
            Button btnSender = sender as Button;
            string TableID = btnSender.Attributes["data-TableID"];
            hdnTableName.Value = TableID;
            lblTableName.Text = btnSender.Text;
        }

        protected void btnResetCustomer_Click(object sender, EventArgs e)
        {
            AddCustomerToOrder(new UserAccount());
            txtEmail.Text = string.Empty;
            ddlSalutation.SelectedIndex = 0;
            txtFirstName.Text = string.Empty;
            txtLastName.Text = string.Empty;
            txtEmail.Text = string.Empty;
            txtMobileNo.Text = string.Empty;
            txtPhoneNo.Text = string.Empty;
            txtAddress1.Text = string.Empty;
            txtAddress2.Text = string.Empty;
            txtCity.Text = string.Empty;
            txtState.Text = string.Empty;
            ddlCountry.SelectedIndex = 0;
            txtPostalCode.Text = string.Empty;
            lblCustomerName.Text = string.Empty;
        }

        private void AddCustomerToOrder(UserAccount currentUser)
        {
            WebSession.CurrentPOSOrders.UsersAccountID = currentUser.UniqueID;
            WebSession.CurrentPOSOrders.FirstName = currentUser.FirstName;
            WebSession.CurrentPOSOrders.LastName = currentUser.LastName;
            WebSession.CurrentPOSOrders.Email = currentUser.Email;
            WebSession.CurrentPOSOrders.BillingAddress1 = currentUser.Address1;
            WebSession.CurrentPOSOrders.BillingAddress2 = currentUser.Address2;
            WebSession.CurrentPOSOrders.BillingCity = currentUser.City;
            WebSession.CurrentPOSOrders.BillingState = currentUser.StateProvince;
            WebSession.CurrentPOSOrders.BillingCountry = currentUser.Country;
            WebSession.CurrentPOSOrders.BillingPostalCode = currentUser.PostalCode;
            WebSession.CurrentPOSOrders.BillingPhone = currentUser.PhoneNo;
            WebSession.CurrentPOSOrders.BillingMobile = currentUser.MobileNo;
            WebSession.CurrentPOSOrders.IsShipToBillingAddress = true;
            if (WebSession.CurrentPOSOrders.IsShipToBillingAddress)
            {
                WebSession.CurrentPOSOrders.ShippingAddress1 = WebSession.CurrentPOSOrders.BillingAddress1;
                WebSession.CurrentPOSOrders.ShippingAddress2 = WebSession.CurrentPOSOrders.BillingAddress2;
                WebSession.CurrentPOSOrders.ShippingCity = WebSession.CurrentPOSOrders.BillingCity;
                WebSession.CurrentPOSOrders.ShippingState = WebSession.CurrentPOSOrders.BillingState;
                WebSession.CurrentPOSOrders.ShippingCountry = WebSession.CurrentPOSOrders.BillingCountry;
                WebSession.CurrentPOSOrders.ShippingPostalCode = WebSession.CurrentPOSOrders.BillingPostalCode;
                WebSession.CurrentPOSOrders.ShippingPhone = WebSession.CurrentPOSOrders.BillingPhone;
                WebSession.CurrentPOSOrders.ShippingMobile = WebSession.CurrentPOSOrders.BillingMobile;
            }
        }

        protected void gvTax_DataBound(object sender, EventArgs e)
        {
            WebSession.CurrentPOSOrders = (WebSession.CurrentPOSOrders == null) ? new Orders() : WebSession.CurrentPOSOrders;
            List<OrdersTax> TaxOrders = new List<OrdersTax>();
            OrdersTax TaxOrder;
            foreach (Tax tx in (gvTax.DataSource as List<Tax>))
            {
                if (tx.ApplyTaxAsDefault)
                {
                    TaxOrder = new OrdersTax();
                    TaxOrder.TaxID = tx.TaxID;
                    TaxOrder.TaxName = tx.TaxName;
                    TaxOrder.TaxType = tx.TaxType;
                    TaxOrder.TaxValue = tx.TaxValue;
                    TaxOrders.Add(TaxOrder);
                }
            }
            WebSession.CurrentPOSOrders.OrdersTax = TaxOrders;
        }

        protected void btnSizeSelect_Click(object sender, EventArgs e)
        {
            Button SelectedProduct = sender as Button;
            Guid MeasurementID = Guid.Parse(SelectedProduct.Attributes["data-SizeID"].ToString());
            Guid ProductID = Guid.Parse(hdnProductSize.Value);
            Products Prod = ProductsBL.GetItem(ProductID, string.Empty);
            Products CurrentProduct = ProductsBL.GetList(Guid.Empty, string.Empty).Where(a => a.ProductName == Prod.ProductName && a.ProductMeasurementID == MeasurementID && a.IsActive).SingleOrDefault();
            if (CurrentProduct != null)
            {
                AzvicService WebSrvObj = new AzvicService();
                WebSrvObj.AddProduct(CurrentProduct.UniqueID, 1, 'A');
            }
        }

        protected void btnOpenSelectSize_Click(object sender, EventArgs e)
        {
            Guid ProductID = Guid.Parse(hdnProductSize.Value);
            List<Products> AllProducts = ProductsBL.GetList(Guid.Empty, string.Empty);
            if (AllProducts != null && AllProducts.Count > 0)
            {
                AllProducts = AllProducts.Where(a => a.IsActive).ToList<Products>();
            }
            List<ProductMeasurement> AllSizes = ProductMeasurementBL.GetList(Guid.Empty, string.Empty);
            if (AllSizes != null && AllSizes.Count > 0)
            {
                AllSizes = AllSizes.Where(a => a.IsActive).ToList<ProductMeasurement>();
            }
            List<ProductMeasurement> ProductSizes = new List<ProductMeasurement>();
            Products CurrentProduct = ProductsBL.GetItem(ProductID, string.Empty);
            AllProducts = AllProducts.Where(a => a.ProductName == CurrentProduct.ProductName).ToList<Products>();
            //Multiple Products in Same name = Different Sizes
            if (AllProducts.Count > 1)
            {
                foreach (Products pd in AllProducts)
                {
                    ProductSizes.Add(AllSizes.Where(a => a.UniqueID == pd.ProductMeasurementID).SingleOrDefault());
                }
                rpProductSize.DataSource = ProductSizes;
                rpProductSize.DataBind();
                ScriptManager.RegisterStartupScript(this, this.GetType(), "Open Size", "$('#divSelectSize').modal('show');", true);

            }
            else
            {
                AzvicService WebSrvObj = new AzvicService();
                WebSrvObj.AddProduct(CurrentProduct.UniqueID, 1, 'A');
                //ScriptManager.RegisterStartupScript(this, this.GetType(), "Open Size", string.Format("AddProductToCart('{0}')",ProductID), true);          
            }
        }

        private void PrintReceipt()
        {
            ScriptManager.RegisterStartupScript(this, this.GetType(), "Print", "PrintReceipt();", true);
        }

        protected void btnApplyGST_Click(object sender, EventArgs e)
        {
            if (WebSession.CurrentGSTSetting)
            {
                WebSession.CurrentGSTSetting = false;
                btnApplyGST.InnerText = "Apply GST";
            }
            else
            {
                WebSession.CurrentGSTSetting = true;
                btnApplyGST.InnerText = "Cancel GST";
            }
        }

        protected void btnSavePendingTransaction_Click(object sender, EventArgs e)
        {
            if (WebSession.CurrentPOSOrders != null && WebSession.CurrentPOSOrders.OrdersDetailsList.Count > 0)
            {
                WebSession.CurrentPOSOrders.OrderFrom = WebSession.GetConfigValue<string>("OrdersFrom");
                string TableName=string.Empty;
                if(!string.IsNullOrEmpty(hdnTableName.Value))
                TableName = LayoutBL.GetItem(Guid.Parse(hdnTableName.Value)).TableName;
                WebSession.CurrentPOSOrders.TableNumber = TableName;
                WebSession.CurrentPOSOrders.UsersAccountID = (WebSession.CurrentPOSOrders.UsersAccountID != Guid.Empty ? WebSession.CurrentPOSOrders.UsersAccountID : Guid.Empty);
                WebSession.CurrentPOSOrders.AdminUserAccountID = (WebSession.CurrentPOSOrders.AdminUserAccountID != Guid.Empty ? WebSession.CurrentPOSOrders.AdminUserAccountID : Guid.Empty);
                WebSession.CurrentPOSOrders.IsShipToBillingAddress = true;
                WebSession.CurrentPOSOrders.ShippingOption = "";
                WebSession.CurrentPOSOrders.Total = WebSession.CurrentPOSOrders.TotalBeforeGST + WebSession.CurrentPOSOrders.GST + WebSession.CurrentPOSOrders.Shipping;
                WebSession.CurrentPOSOrders.PaymentStatus = "Pending";
                WebSession.CurrentPOSOrders.OrderStatus = "New";
                WebSession.CurrentPOSOrders.EarliestAvailableDate = DateTime.MinValue;


                if (OrdersBL.Save(WebSession.CurrentPOSOrders))
                {
                    WebSession.CurrentPOSOrders = new Orders();
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "Open Table", "ShowSelectTable();", true);
                }
            }
        }
    }
}